
import javax.swing.*;
import java.awt.*;

/**
 * Predictive recursive descent parsing.
 *
 * @author Dung X. Nguyen, Stephen Wong, and Mathias Ricken
 * @version 2.0
 */
public class RDPApp {
    /**
     * Pack frame?
     */
    boolean packFrame = false;

    /**
     * Constructor for the application.
     */
    public RDPApp() {
        RDPFrame frame = new RDPFrame();
        //Validate frames that have preset sizes
        //Pack frames that have useful preferred size info, e.g. from their layout
        if (packFrame) {
            frame.pack();
        }
        else {
            frame.validate();
        }

        //Center the window
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    /**
     * Main method.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new RDPApp();
    }
}